<?php
	require('./autoloader.php');
	include('sample.php');
	use Metaregistrar\EPP\eppConnection;
	try {
		if ($conn = eppConnection::create('')) {
			if ($conn->login()) {
				# request and response
				$xml = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <epp xmlns="urn:ietf:params:xml:ns:epp-1.0"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"  xsi:schemaLocation="urn:ietf:params:xml:ns:epp-1.0 epp-1.0.xsd">
  <command xmlns="urn:ietf:params:xml:ns:epp-1.0">
    <check>
      <domain:check xmlns:domain="urn:ietf:params:xml:ns:domain-1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd">
        <domain:name>test.com.tw</domain:name>
      </domain:check>
    </check>
    <clTRID>ABC-91478-XYZ</clTRID>
  </command>
  </epp>';
				$rc = request($xml);
				if(getAttr($rc,"result","code") == 1000)
				{
					$msg = getAttr($rc,'result','code');
					$avail = getAttr($rc,"contact:id","avail");
				}
				$conn->logout();
			}
		}
	} catch (eppException $e) {
		echo "ERROR: " . $e->getMessage() . "\n\n";
	}
	
	
	
	function request($xml) {
		echo format($xml)."\n\n";
		$response = format($GLOBALS['conn']->sendrequest($xml));
		echo $response."\n\n";
		return $response."\n\n";
	}
	
	function format($xml)
	{
		$dom = new DOMDocument();
		$dom->formatOutput = true;
		$dom->loadXML($xml);
		return $dom->saveXML();
	}
	function getValue($xml,$tag,$attr = null,$val = null)
	{
		$lines = explode("\n",$xml);
		for($i = 0;$i < count($lines);$i++)
			if(preg_match("/<{$tag}.*\>(.*)<\/{$tag}.*\>/",$lines[$i],$rc) and $attr == null)
				return $rc[1];
			else if(preg_match("/<{$tag}\s*{$attr}=['|\"]{$val}['|\"]>(.*)</",$lines[$i],$rc) and $attr != null)
				return $rc[1];
				
	}
	function getAttr($xml,$tag,$attr)
	{
		$lines = explode("\n",$xml);
		for($i = 0;$i < count($lines);$i++)
			if(preg_match("/<{$tag}\s*{$attr}=['|\"](.*)['|\"]>.*/",$lines[$i],$rc))
				return $rc[1];
	}
?>